************************************
MACRO for CPS 1968-72 (Survey Year)
TAXSIM (Federal)Tax information
Program 2 of 4

5/3/10:  EDITED TO RUN ON JIM'S COMPUTER


************************************;
filename out1968 "N:\Private\Poverty Trends\SAS\cps\output\taxsim1968.txt";
filename out1969 "N:\Private\Poverty Trends\SAS\cps\output\taxsim1969.txt";
filename out1970 "N:\Private\Poverty Trends\SAS\cps\output\taxsim1970.txt";
filename out1971 "N:\Private\Poverty Trends\SAS\cps\output\taxsim1971.txt";
filename out1972 "N:\Private\Poverty Trends\SAS\cps\output\taxsim1972.txt";

%macro taxfed6872(yr);
*************************************
Taxsim Program Federal Taxes
*************************************;

proc sort data=cpsdata.cps&yr;
by famid;
run;

data taxsim&yr;
set cpsdata.cps&yr;
by famid;

* Create var for person number to be used in id var;
RETAIN counter 0; 
counter= counter+1;
IF FIRST.famid THEN DO; 
counter=1;
END;

/* This is the value for the gross income test for dependents.  It is the same
   as the personal exemption.  
   See data h:data\tax\tax_parameters_taxpolicycenter.org.xls
   The parameters are for tax years 1971-2005--CPS years 1972-2004
*/
	IF &yr=1972 THEN inc_test=675;
	
	IF &yr=1971 THEN inc_test=625;

	IF &yr IN (1970 1969 1968)then inc_test=600;
	
 
	 

* Creat dependents var, including both children and non-working unmarried relatives;
IF 		(famrel2 IN(4,7,9,12,13,15,16,19,21,24) OR 27 LE famrel2 LE 31)
		/* don't work at all or work little because you go to school */
		AND (rsnnotw NE 0 OR (wkswrk IN (0,1,2) AND rsnnotl=4)) 
		AND marstat IN(0,1,6,7) 
		AND ptotinc LT inc_test 
		THEN dep=1;

* allow married non-working children 19-23 to be dependents;
ELSE IF (famrel2 IN(4,7,9,12,13,15,16,19,21,24) OR 27 LE famrel2 LE 31) 
			AND 19 LE age LE 23 
			/* don't work at all or work little because you go to school */
			AND (rsnnotw NE 0 OR (wkswrk IN (0,1,2) AND rsnnotl=4)) THEN dep=1;

* allow all children under 19 to be dependents;
ELSE IF (famrel2 IN(4,7,9,12,13,15,16,19,21,24) OR 27 LE famrel2 LE 31) 
			AND age LE 18 THEN dep=1;
ELSE dep=0;

* calc num of kids for fed child tax credit;
IF (famrel2 IN(4,7,9,12,13,15,16,19,21,24) OR 27 LE famrel2 LE 31) 
			AND age LE 16 THEN kids3=1;
ELSE kids3=0;

* calc num of eitc kids;
IF (famrel2 IN(4,7,9,12,13,15,16,19,21,24) OR 27 LE famrel2 LE 31) 
			AND age LE 18 THEN kids2=1;
ELSE IF (famrel2 IN(4,7,9,12,13,15,16,19,21,24) OR 27 LE famrel2 LE 31) 
			AND 19 LE age LE 23 
			AND (rsnnotw IN(1,3) OR (wkswrk IN (0,1,2) AND rsnnotl IN(2,4))) THEN kids2=1;
ELSE kids2=0;

* calc num of taxpayers over 65, exclude dependents over 65;
IF age GT 65 AND dep=0 THEN gt65=1;
ELSE gt65=0;

IF famrel2 IN(2,6,11,18,23,26) THEN wife_inc=ptotearn;
ELSE wife_inc=0;

run;

proc sort data=taxsim&yr;
by famid;
run;

proc means data=taxsim&yr sum noprint;
by famid;
* restrict to husbands, wives, and their dependents;
where famrel2 IN(1,2,3,5,6,8,10,11,14,17,18,20,22,23,25,26) OR dep=1;
var dep kids2 kids3 wife_inc gt65 ssinc intinc divinc uiinc retinc alimony ptotearn;
output out=temp1 sum=totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					 tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
run;

data cpsdata.taxsim&yr;
merge taxsim&yr(IN=in1) temp1(KEEP=famid totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn);
by famid;
if in1;

* Restrict sample to heads of tax filing unit;
* Delete spouses;
IF famrel2 IN(2,6,11,18,23,26) THEN DELETE;
* Delete dependents;
IF dep=0;

     ARRAY tax_vars totdep kid_eitc kid_fcc tfu_wifi tfu_gt65 tfu_ss tfu_int 
					            tfu_div tfu_ui tfu_ret tfu_alm tfu_earn;
	 DO OVER tax_vars;
	 IF tax_vars=. THEN tax_vars=0;
	 END; 

*adjustments for taxsim;
tfu_wifi=MAX(tfu_wifi,0);
totdep=MIN(totdep,15);
kid_eitc=MIN(kid_eitc,15);
kid_fcc=MIN(kid_fcc,15);


IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN taxinc=tfu_earn-tfu_wifi;
ELSE taxinc=ptotearn;
taxinc=MAX(taxinc,0);

IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN inc9=tfu_div;
ELSE inc9=divinc;
inc9=MAX(inc9,0);

IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN inc10=tfu_int;
ELSE inc10=intinc;

IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN inc11=tfu_ret;
ELSE inc11=retinc;

IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN inc12=tfu_ss;
ELSE inc12=ssinc;

IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN inc18=tfu_ui;
ELSE inc18=uiinc;

IF famrel2 IN(1,3,5,8,10,14,17,20,22,25) THEN num_gt65=tfu_gt65;
ELSE num_gt65=gt65;

id=famid*100+counter;

IF marstat IN(2,4,5) THEN filestat=2;
   ELSE IF totdep GT 0 AND marstat IN(1,3,6,7) THEN filestat=3;
   ELSE filestat=1;

***********************************************************
Recode from CPS state id to the SOI state id used by taxsim
dont know what state2=25 means so make them ny
***********************************************************;

IF state2=11 THEN state=7;
ELSE IF state2=19 THEN state=22;
ELSE IF state2=21 THEN state=33;
ELSE IF state2=22 THEN state=31;
ELSE IF state2=23 THEN state=39;
ELSE IF state2=31 THEN state=36;
ELSE IF state2=32 THEN state=15;
ELSE IF state2=33 THEN state=14;
ELSE IF state2=39 THEN state=23;
ELSE IF state2=41 THEN state=24;
ELSE IF state2=43 THEN state=26;
ELSE IF state2=49 THEN state=17;
ELSE IF state2=51 THEN state=9;
ELSE IF state2=52 THEN state=21;
ELSE IF state2=53 THEN state=49;
ELSE IF state2=54 THEN state=11;
ELSE IF state2=55 THEN state=10;
ELSE IF state2=57 THEN state=34;
ELSE IF state2=59 THEN state=47;
ELSE IF state2=61 THEN state=18;
ELSE IF state2=62 THEN state=43;
ELSE IF state2=69 THEN state=1;
ELSE IF state2=71 THEN state=19;
ELSE IF state2=72 THEN state=44;
ELSE IF state2=79 THEN state=37;
ELSE IF state2=81 THEN state=6;
ELSE IF state2=89 THEN state=45;
ELSE IF state2=91 THEN state=38;
ELSE IF state2=92 THEN state=5;
ELSE IF state2=99 THEN state=48;
ELSE IF state2=25 THEN state=33;



fill=0;

KEEP id ref_year state filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill inc18 kid_fcc kid_eitc;
RUN;


DATA _NULL_;
   SET cpsdata.taxsim&yr;
   FILE out&yr lrecl=500;
   PUT id ref_year fill filestat totdep num_gt65 taxinc tfu_wifi
   inc9 inc10 inc11 inc12 fill fill fill fill fill inc18 kid_fcc fill fill fill;
RUN;

%mend taxfed6872;
%taxfed6872(1968);
%taxfed6872(1969);
%taxfed6872(1970);
%taxfed6872(1971);
%taxfed6872(1972);

*****************************************************************************
Before you run the next step (Name for Federal Tax Macro), you must 
run these text files created for each year through the NBER Taxsim
calculator.  Save each output file in your taxsim library location, 
i.e. in this example "C:\Documents and Settings\Tommy\My Documents\taxsim"
which is the location of the taxsim library.  Each output file should be
saved as taxsim.taxsim&yr.txt.  Run these files through the NBER Taxsim 
calculator and save the corresponding output file as taxsim&yrout.txt (text 
file) in the same taxsim folder so the file directory should read 
C:\Documents and Settings\Tommy\My Documents\taxsim\taxsim&yrout.txt
I.E. for 1972: 
C:\Documents and Settings\Tommy\My Documents\taxsim\taxsim1972out.txt
These taxsim&yrout text files will contain the final federal tax liabilities 
for the corresponding individuals in the CPS
*****************************************************************************:
